/*! For license information please see twofactor_backupcodes-settings.js.LICENSE.txt */
(()=>{"use strict";var e,n,o,a={27342:(e,n,o)=>{var a=o(32981),r=o(85471),s=o(56760);o(51257);const c={name:"PersonalSettings",data:()=>({generatingCodes:!1}),computed:{downloadUrl(){return this.codes?"data:text/plain,"+encodeURIComponent(this.codes.reduce(((t,e)=>t+e+"\r\n"),"")):""},downloadFilename:()=>(OC.theme.name||"Nextcloud")+"-backup-codes.txt",enabled(){return this.$store.state.enabled},total(){return this.$store.state.total},used(){return this.$store.state.used},codes(){return this.$store.state.codes},name:()=>OC.theme.name||"Nextcloud",haveCodes(){return this.codes&&this.codes.length>0}},methods:{generateBackupCodes(){(0,s.C5)().then((()=>{this.generatingCodes=!0,this.$store.dispatch("generate").then((t=>{this.generatingCodes=!1})).catch((e=>{throw OC.Notification.showTemporary(t("twofactor_backupcodes","An error occurred while generating your backup codes")),this.generatingCodes=!1,e}))})).catch(console.error.bind(this))},getPrintData:t=>t?t.reduce(((t,e)=>t+e+"<br>"),""):"",printCodes(){!function(e){const n=OC.theme.name||"Nextcloud",o=window.open("",t("twofactor_backupcodes","{name} backup codes",{name:n}));o.document.write("<h1>"+t("twofactor_backupcodes","{name} backup codes",{name:n})+"</h1>"),o.document.write("<pre>"+e+"</pre>"),o.print(),o.close()}(this.getPrintData(this.codes))}}};var d=o(85072),i=o.n(d),l=o(97825),u=o.n(l),p=o(77659),b=o.n(p),h=o(55056),m=o.n(h),f=o(10540),g=o.n(f),v=o(41113),k=o.n(v),w=o(53673),C={};C.styleTagTransform=k(),C.setAttributes=m(),C.insert=b().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=g(),i()(w.A,C),w.A&&w.A.locals&&w.A.locals;const y=(0,o(14486).A)(c,(function(){var t=this,e=t._self._c;return e("div",[t.enabled?[e("p",[t.haveCodes?[t._v("\n\t\t\t\t"+t._s(t.t("twofactor_backupcodes","These are your backup codes. Please save and/or print them as you will not be able to read the codes again later"))+"\n\t\t\t\t"),e("ul",t._l(t.codes,(function(n){return e("li",{key:n,staticClass:"backup-code"},[t._v("\n\t\t\t\t\t\t"+t._s(n)+"\n\t\t\t\t\t")])})),0),t._v(" "),e("a",{staticClass:"button primary",attrs:{href:t.downloadUrl,download:t.downloadFilename}},[t._v(t._s(t.t("twofactor_backupcodes","Save backup codes")))]),t._v(" "),e("button",{staticClass:"button",on:{click:t.printCodes}},[t._v("\n\t\t\t\t\t"+t._s(t.t("twofactor_backupcodes","Print backup codes"))+"\n\t\t\t\t")])]:[t._v("\n\t\t\t\t"+t._s(t.t("twofactor_backupcodes","Backup codes have been generated. {used} of {total} codes have been used.",{used:t.used,total:t.total}))+"\n\t\t\t")]],2),t._v(" "),e("p",[e("button",{attrs:{id:"generate-backup-codes"},on:{click:t.generateBackupCodes}},[t._v("\n\t\t\t\t"+t._s(t.t("twofactor_backupcodes","Regenerate backup codes"))+"\n\t\t\t")])]),t._v(" "),e("p",[e("em",[t._v("\n\t\t\t\t"+t._s(t.t("twofactor_backupcodes","If you regenerate backup codes, you automatically invalidate old codes."))+"\n\t\t\t")])])]:e("button",{attrs:{id:"generate-backup-codes",disabled:t.generatingCodes},on:{click:t.generateBackupCodes}},[t._v("\n\t\t"+t._s(t.t("twofactor_backupcodes","Generate backup codes"))+"\n\t\t"),e("span",{class:{"icon-loading-small":t.generatingCodes}})])],2)}),[],!1,null,"142ef146",null).exports;var A=o(95353),_=o(65043),P=o(63814);r.Ay.use(A.Ay);const x={setEnabled(t,e){r.Ay.set(t,"enabled",e)},setTotal(t,e){r.Ay.set(t,"total",e)},setUsed(t,e){r.Ay.set(t,"used",e)},setCodes(t,e){r.Ay.set(t,"codes",e)}},O={generate(t){let{commit:e}=t;return e("setEnabled",!1),function(){const t=(0,P.Jv)("/apps/twofactor_backupcodes/settings/create");return _.Ay.post(t,{}).then((t=>t.data))}().then((t=>{let{codes:n,state:o}=t;return e("setEnabled",o.enabled),e("setTotal",o.total),e("setUsed",o.used),e("setCodes",n),!0}))}},S=new A.il({strict:!1,state:{enabled:!1,total:0,used:0,codes:[]},mutations:x,actions:O});r.Ay.prototype.t=t;const T=(0,a.C)("twofactor_backupcodes","state");S.replaceState(T),new(r.Ay.extend(y))({store:S}).$mount("#twofactor-backupcodes-settings")},53673:(t,e,n)=>{n.d(e,{A:()=>c});var o=n(71354),a=n.n(o),r=n(76314),s=n.n(r)()(a());s.push([t.id,"\n.backup-code[data-v-142ef146] {\n\tfont-family: monospace;\n\tletter-spacing: 0.02em;\n\tfont-size: 1.2em;\n}\n.button[data-v-142ef146] {\n\tdisplay: inline-block;\n}\n","",{version:3,sources:["webpack://./apps/twofactor_backupcodes/src/views/PersonalSettings.vue"],names:[],mappings:";AAoIA;CACA,sBAAA;CACA,sBAAA;CACA,gBAAA;AACA;AACA;CACA,qBAAA;AACA",sourcesContent:["<template>\n\t<div>\n\t\t<button v-if=\"!enabled\"\n\t\t\tid=\"generate-backup-codes\"\n\t\t\t:disabled=\"generatingCodes\"\n\t\t\t@click=\"generateBackupCodes\">\n\t\t\t{{ t('twofactor_backupcodes', 'Generate backup codes') }}\n\t\t\t<span :class=\"{'icon-loading-small': generatingCodes}\" />\n\t\t</button>\n\t\t<template v-else>\n\t\t\t<p>\n\t\t\t\t<template v-if=\"!haveCodes\">\n\t\t\t\t\t{{ t('twofactor_backupcodes', 'Backup codes have been generated. {used} of {total} codes have been used.', {used, total}) }}\n\t\t\t\t</template>\n\t\t\t\t<template v-else>\n\t\t\t\t\t{{ t('twofactor_backupcodes', 'These are your backup codes. Please save and/or print them as you will not be able to read the codes again later') }}\n\t\t\t\t\t<ul>\n\t\t\t\t\t\t<li v-for=\"code in codes\" :key=\"code\" class=\"backup-code\">\n\t\t\t\t\t\t\t{{ code }}\n\t\t\t\t\t\t</li>\n\t\t\t\t\t</ul>\n\t\t\t\t\t<a :href=\"downloadUrl\"\n\t\t\t\t\t\tclass=\"button primary\"\n\t\t\t\t\t\t:download=\"downloadFilename\">{{ t('twofactor_backupcodes', 'Save backup codes') }}</a>\n\t\t\t\t\t<button class=\"button\"\n\t\t\t\t\t\t@click=\"printCodes\">\n\t\t\t\t\t\t{{ t('twofactor_backupcodes', 'Print backup codes') }}\n\t\t\t\t\t</button>\n\t\t\t\t</template>\n\t\t\t</p>\n\t\t\t<p>\n\t\t\t\t<button id=\"generate-backup-codes\"\n\t\t\t\t\t@click=\"generateBackupCodes\">\n\t\t\t\t\t{{ t('twofactor_backupcodes', 'Regenerate backup codes') }}\n\t\t\t\t</button>\n\t\t\t</p>\n\t\t\t<p>\n\t\t\t\t<em>\n\t\t\t\t\t{{ t('twofactor_backupcodes', 'If you regenerate backup codes, you automatically invalidate old codes.') }}\n\t\t\t\t</em>\n\t\t\t</p>\n\t\t</template>\n\t</div>\n</template>\n\n<script>\nimport { confirmPassword } from '@nextcloud/password-confirmation'\nimport '@nextcloud/password-confirmation/dist/style.css'\nimport { print } from '../service/PrintService.js'\n\nexport default {\n\tname: 'PersonalSettings',\n\tdata() {\n\t\treturn {\n\t\t\tgeneratingCodes: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tdownloadUrl() {\n\t\t\tif (!this.codes) {\n\t\t\t\treturn ''\n\t\t\t}\n\t\t\treturn 'data:text/plain,' + encodeURIComponent(this.codes.reduce((prev, code) => {\n\t\t\t\treturn prev + code + '\\r\\n'\n\t\t\t}, ''))\n\t\t},\n\t\tdownloadFilename() {\n\t\t\tconst name = OC.theme.name || 'Nextcloud'\n\t\t\treturn name + '-backup-codes.txt'\n\t\t},\n\t\tenabled() {\n\t\t\treturn this.$store.state.enabled\n\t\t},\n\t\ttotal() {\n\t\t\treturn this.$store.state.total\n\t\t},\n\t\tused() {\n\t\t\treturn this.$store.state.used\n\t\t},\n\t\tcodes() {\n\t\t\treturn this.$store.state.codes\n\t\t},\n\t\tname() {\n\t\t\treturn OC.theme.name || 'Nextcloud'\n\t\t},\n\t\thaveCodes() {\n\t\t\treturn this.codes && this.codes.length > 0\n\t\t},\n\t},\n\tmethods: {\n\t\tgenerateBackupCodes() {\n\t\t\tconfirmPassword().then(() => {\n\t\t\t\t// Hide old codes\n\t\t\t\tthis.generatingCodes = true\n\n\t\t\t\tthis.$store.dispatch('generate').then(data => {\n\t\t\t\t\tthis.generatingCodes = false\n\t\t\t\t}).catch(err => {\n\t\t\t\t\tOC.Notification.showTemporary(t('twofactor_backupcodes', 'An error occurred while generating your backup codes'))\n\t\t\t\t\tthis.generatingCodes = false\n\t\t\t\t\tthrow err\n\t\t\t\t})\n\t\t\t}).catch(console.error.bind(this))\n\t\t},\n\n\t\tgetPrintData(codes) {\n\t\t\tif (!codes) {\n\t\t\t\treturn ''\n\t\t\t}\n\t\t\treturn codes.reduce((prev, code) => {\n\t\t\t\treturn prev + code + '<br>'\n\t\t\t}, '')\n\t\t},\n\n\t\tprintCodes() {\n\t\t\tprint(this.getPrintData(this.codes))\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n\t.backup-code {\n\t\tfont-family: monospace;\n\t\tletter-spacing: 0.02em;\n\t\tfont-size: 1.2em;\n\t}\n\t.button {\n\t\tdisplay: inline-block;\n\t}\n</style>\n"],sourceRoot:""}]);const c=s}},r={};function s(t){var e=r[t];if(void 0!==e)return e.exports;var n=r[t]={id:t,loaded:!1,exports:{}};return a[t].call(n.exports,n,n.exports,s),n.loaded=!0,n.exports}s.m=a,e=[],s.O=(t,n,o,a)=>{if(!n){var r=1/0;for(l=0;l<e.length;l++){n=e[l][0],o=e[l][1],a=e[l][2];for(var c=!0,d=0;d<n.length;d++)(!1&a||r>=a)&&Object.keys(s.O).every((t=>s.O[t](n[d])))?n.splice(d--,1):(c=!1,a<r&&(r=a));if(c){e.splice(l--,1);var i=o();void 0!==i&&(t=i)}}return t}a=a||0;for(var l=e.length;l>0&&e[l-1][2]>a;l--)e[l]=e[l-1];e[l]=[n,o,a]},s.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return s.d(e,{a:e}),e},s.d=(t,e)=>{for(var n in e)s.o(e,n)&&!s.o(t,n)&&Object.defineProperty(t,n,{enumerable:!0,get:e[n]})},s.f={},s.e=t=>Promise.all(Object.keys(s.f).reduce(((e,n)=>(s.f[n](t,e),e)),[])),s.u=t=>t+"-"+t+".js?v="+{2441:"bd6d3dc836e836cd4795",5775:"2db0bc22d25dcd7b0e81",5862:"18c97d281a8207f0ce8d"}[t],s.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),s.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n={},o="nextcloud:",s.l=(t,e,a,r)=>{if(n[t])n[t].push(e);else{var c,d;if(void 0!==a)for(var i=document.getElementsByTagName("script"),l=0;l<i.length;l++){var u=i[l];if(u.getAttribute("src")==t||u.getAttribute("data-webpack")==o+a){c=u;break}}c||(d=!0,(c=document.createElement("script")).charset="utf-8",c.timeout=120,s.nc&&c.setAttribute("nonce",s.nc),c.setAttribute("data-webpack",o+a),c.src=t),n[t]=[e];var p=(e,o)=>{c.onerror=c.onload=null,clearTimeout(b);var a=n[t];if(delete n[t],c.parentNode&&c.parentNode.removeChild(c),a&&a.forEach((t=>t(o))),e)return e(o)},b=setTimeout(p.bind(null,void 0,{type:"timeout",target:c}),12e4);c.onerror=p.bind(null,c.onerror),c.onload=p.bind(null,c.onload),d&&document.head.appendChild(c)}},s.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},s.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),s.j=4423,(()=>{var t;s.g.importScripts&&(t=s.g.location+"");var e=s.g.document;if(!t&&e&&(e.currentScript&&"SCRIPT"===e.currentScript.tagName.toUpperCase()&&(t=e.currentScript.src),!t)){var n=e.getElementsByTagName("script");if(n.length)for(var o=n.length-1;o>-1&&(!t||!/^http(s?):/.test(t));)t=n[o--].src}if(!t)throw new Error("Automatic publicPath is not supported in this browser");t=t.replace(/^blob:/,"").replace(/#.*$/,"").replace(/\?.*$/,"").replace(/\/[^\/]+$/,"/"),s.p=t})(),(()=>{s.b=document.baseURI||self.location.href;var t={4423:0};s.f.j=(e,n)=>{var o=s.o(t,e)?t[e]:void 0;if(0!==o)if(o)n.push(o[2]);else{var a=new Promise(((n,a)=>o=t[e]=[n,a]));n.push(o[2]=a);var r=s.p+s.u(e),c=new Error;s.l(r,(n=>{if(s.o(t,e)&&(0!==(o=t[e])&&(t[e]=void 0),o)){var a=n&&("load"===n.type?"missing":n.type),r=n&&n.target&&n.target.src;c.message="Loading chunk "+e+" failed.\n("+a+": "+r+")",c.name="ChunkLoadError",c.type=a,c.request=r,o[1](c)}}),"chunk-"+e,e)}},s.O.j=e=>0===t[e];var e=(e,n)=>{var o,a,r=n[0],c=n[1],d=n[2],i=0;if(r.some((e=>0!==t[e]))){for(o in c)s.o(c,o)&&(s.m[o]=c[o]);if(d)var l=d(s)}for(e&&e(n);i<r.length;i++)a=r[i],s.o(t,a)&&t[a]&&t[a][0](),t[a]=0;return s.O(l)},n=self.webpackChunknextcloud=self.webpackChunknextcloud||[];n.forEach(e.bind(null,0)),n.push=e.bind(null,n.push.bind(n))})(),s.nc=void 0;var c=s.O(void 0,[4208],(()=>s(27342)));c=s.O(c)})();
//# sourceMappingURL=twofactor_backupcodes-settings.js.map?v=58da7741467216301a73